/**********************************************************************/
/*                                                                    */
/* Project Name:  G128 - CRG - 25MHz PEI mode - CW50                  */
/* Last modified: 05/01/2011                                          */
/* By:            b01802                                              */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
/*                                                                    */
/* Description: Set the bus clock 25MHz in PEI mode                   */
/*                                                                    */
/*                                                                    */
/* Documentation: MC9S12GRMV1.pdf                                     */
/*                                                                    */
/*                                                                    */
/* This software is classified as Engineering Sample Software.        */
/*                                                                    */
/**********************************************************************/
/*                                                                    */
/* Services performed by FREESCALE in this matter are performed AS IS */
/* and without any warranty. CUSTOMER retains the final decision      */
/* relative to the total design and functionality of the end product. */ 
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER   */
/* for the success of this project. FREESCALE DISCLAIMS ALL           */
/* WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING, BUT NOT     */
/* LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR  FITNESS FOR A  */
/* PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED   */
/* TO THE PROJECT BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM     */
/* FREESCALE SERVICES . IN NO EVENT SHALL FREESCALE BE LIABLE FOR     */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS AGREEMENT. */
/*                                                                    */
/* CUSTOMER agrees to hold FREESCALE harmless against any and all     */
/* claims demands or actions by anyone on account of any damage, or   */
/* injury, whether commercial, contractual, or tortuous, rising       */
/* directly or indirectly as a result of the advise or assistance     */
/* supplied CUSTOMER in connection with product, services or goods    */
/* supplied under this Agreement.                                     */
/*                                                                    */
/**********************************************************************/

#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */


//==============================================================================
//Important formulas:

//if external oscillator is enabled (OSCE = 1)
//  fref = fosc / (REFDIV + 1)

//if external oscillator is disabled (OSCE = 0)
//  fref = fIRC1M

//  fvco = 2 * fref * (SYNDIV + 1)

//if PLL is locked (LOCK = 1)
//  fpll = fvco / (POSTDIV + 1)

//if PLL is not locked (LOCK = 0)
//  fpll = fvco / 4

//if PLL is selected (PLLSEL = 1)
//  fbus = fpll / 2
//==============================================================================


//==============================================================================
//Delay
//==============================================================================
void Delay(void)
{
  unsigned int i,j;    
  
  for(i=0; i<65500; i++)  
    for(j=0; j<100; j++) asm nop;        
}

//==============================================================================
//PLL_LOCK_ISR
//==============================================================================
#pragma CODE_SEG NON_BANKED
interrupt 28 void PLL_LOCK_ISR(void)
{
  if(CPMUFLG_LOCK == 0)
  {
    //do something here
  }
  else
  {
    //do something here
  }
}
#pragma CODE_SEG DEFAULT
                      
//==============================================================================
//Main
//==============================================================================
void main(void) {
  
  
  ECLKCTL_NECLK = 0;  //enable ECLK output (bus clock is visible on pin PE4)
  
  //============================================================================
  //Default state after reset:
  
  //PLL Engaged Internal Mode (PEI)
  //Reference clock = internal RC oscillator 1MHz
  //Default settings:
  //REFDIV[3:0] = 0x0F;
  //REFFRQ[1:0] = 0x00;
  //SYNDIV[5:0] = 0x18;
  //VCOFRQ[1:0] = 0x01;
  //POSTDIV[4:0] = 0x03;
  //fvco = 50MHz
  //fpll = 12.5MHz
  //fbus = 6.25MHz
  
  Delay();    //delay in order to see default bus frequency on ECLK output
    
  //============================================================================
  //We want to set:
  //PLL Engaged Internal Mode (PEI)
  //Reference clock = internal RC oscillator 1MHz
  //REFDIV[3:0] = 0;   - has no effect in PEI mode
  //REFFRQ[1:0] = 0;   - has no effect in PEI mode
  //SYNDIV[5:0] = 0x18;
  //VCOFRQ[1:0] = 0x01;
  //POSTDIV[4:0] = 0x00;
  //fvco = 50MHz
  //fpll = 50MHz
  //fbus = 25MHz
  
  CPMUSYNR_SYNDIV = 0x18;
  CPMUSYNR_VCOFRQ = 0x01;            
  
  CPMUPOSTDIV = 0x00;     
  
  //writing into CPMUSYNR or CPMUREFDIV will unlock the PLL.
  //While PLL is unlocked fpll is fvco/4 to protect the system from high
  //core clock frequencies during the PLL stabilization time. 
  
  //wait until PLL clocks are within the desired tolerance of target frequency
  while(!CPMUFLG_LOCK);  
  //now the PLL has been locked and fpll = fvco / (POSTDIV + 1)
  
  
  EnableInterrupts;
  
  //We can enable the interrupt which will be requested whenever LOCKIF is set
  //LOCKIF interrupt flag is set whenever the LOCK status bit has been changed  
  CPMUFLG_LOCKIF = 1;   //clear flag
  CPMUINT_LOCKIE = 1;   //enable interrupt 
  
  
  //test                      
  //CPMUSYNR_SYNDIV = 0x1E; //test - writing into CPMUSYNR or CPMUREFDIV will 
                            //trigger the interrupt because the PLL will
                            //become unlocked  
      
  

  for(;;) {} /* wait forever */
  /* please make sure that you never leave this function */
}